/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.gametest;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement;
import com.simibubi.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovingInteraction;
import com.simibubi.create.content.contraptions.actors.seat.SeatBlock;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.kinetics.gauge.SpeedGaugeBlockEntity;
import com.simibubi.create.content.kinetics.gauge.StressGaugeBlockEntity;
import com.simibubi.create.content.logistics.tunnel.BrassTunnelBlockEntity;
import com.simibubi.create.content.redstone.nixieTube.NixieTubeBlockEntity;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.mixin.accessor.GameTestHelperAccessor;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.createmod.catnip.platform.CatnipServices;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2401;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3499;
import net.minecraft.class_4516;
import net.minecraft.class_4517;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CreateGameTestHelper
extends class_4516 {
    public static final int TICKS_PER_SECOND = 20;
    public static final int TEN_SECONDS = 200;
    public static final int FIFTEEN_SECONDS = 300;
    public static final int TWENTY_SECONDS = 400;

    private CreateGameTestHelper(class_4517 testInfo) {
        super(testInfo);
    }

    public static CreateGameTestHelper of(class_4516 original) {
        GameTestHelperAccessor access = (GameTestHelperAccessor)original;
        CreateGameTestHelper helper = new CreateGameTestHelper(access.getTestInfo());
        GameTestHelperAccessor newAccess = (GameTestHelperAccessor)((Object)helper);
        newAccess.setFinalCheckAdded(access.getFinalCheckAdded());
        return helper;
    }

    public void flipBlock(class_2338 pos) {
        class_2680 original = this.method_35980(pos);
        if (!original.method_28498((class_2769)class_2741.field_12525)) {
            this.method_35995("FACING property not in block: " + class_7923.field_41175.method_10206((Object)original.method_26204()));
        }
        class_2350 facing = (class_2350)original.method_11654((class_2769)class_2741.field_12525);
        class_2680 reversed = (class_2680)original.method_11657((class_2769)class_2741.field_12525, (Comparable)facing.method_10153());
        this.method_35986(pos, reversed);
    }

    public void assertNixiePower(class_2338 pos, int strength) {
        NixieTubeBlockEntity nixie = (NixieTubeBlockEntity)this.getBlockEntity((class_2591)AllBlockEntityTypes.NIXIE_TUBE.get(), pos);
        int actualStrength = nixie.getRedstoneStrength();
        if (actualStrength != strength) {
            this.method_35995("Expected nixie tube at %s to have power of %s, got %s".formatted(pos, strength, actualStrength));
        }
    }

    public void powerLever(class_2338 pos) {
        this.method_35972(class_2246.field_10363, pos);
        if (!((Boolean)this.method_35980(pos).method_11654((class_2769)class_2401.field_11265)).booleanValue()) {
            this.method_36039(pos);
        }
    }

    public void unpowerLever(class_2338 pos) {
        this.method_35972(class_2246.field_10363, pos);
        if (((Boolean)this.method_35980(pos).method_11654((class_2769)class_2401.field_11265)).booleanValue()) {
            this.method_36039(pos);
        }
    }

    public void setTunnelMode(class_2338 pos, BrassTunnelBlockEntity.SelectionMode mode) {
        ScrollValueBehaviour behavior = (ScrollValueBehaviour)this.getBehavior(pos, ScrollOptionBehaviour.TYPE);
        behavior.setValue(mode.ordinal());
    }

    public void assertSpeedometerSpeed(class_2338 speedometer, float value) {
        SpeedGaugeBlockEntity be = (SpeedGaugeBlockEntity)this.getBlockEntity((class_2591)AllBlockEntityTypes.SPEEDOMETER.get(), speedometer);
        this.assertInRange(be.getSpeed(), (double)value - 0.01, (double)value + 0.01);
    }

    public void assertStressometerCapacity(class_2338 stressometer, float value) {
        StressGaugeBlockEntity be = (StressGaugeBlockEntity)this.getBlockEntity((class_2591)AllBlockEntityTypes.STRESSOMETER.get(), stressometer);
        this.assertInRange(be.getNetworkCapacity(), (double)value - 0.01, (double)value + 0.01);
    }

    public void toggleActorsOfType(Contraption contraption, class_1935 item) {
        AtomicBoolean toggled = new AtomicBoolean(false);
        contraption.getInteractors().forEach((localPos, behavior) -> {
            if (toggled.get() || !(behavior instanceof ContraptionControlsMovingInteraction)) {
                return;
            }
            ContraptionControlsMovingInteraction controls = (ContraptionControlsMovingInteraction)behavior;
            MutablePair<class_3499.class_3501, MovementContext> actor = contraption.getActorAt((class_2338)localPos);
            if (actor == null) {
                return;
            }
            class_1799 filter = ContraptionControlsMovement.getFilter((MovementContext)actor.right);
            if (filter != null && filter.method_31574(item.method_8389())) {
                controls.handlePlayerInteraction(this.method_36021(), class_1268.field_5808, (class_2338)localPos, contraption.entity);
                toggled.set(true);
            }
        });
    }

    public <T extends class_2586> T getBlockEntity(class_2591<T> type, class_2338 pos) {
        class_2591 actualType;
        class_2586 be = this.method_36014(pos);
        class_2591 class_25912 = actualType = be == null ? null : be.method_11017();
        if (actualType != type) {
            String actualId = actualType == null ? "null" : CatnipServices.REGISTRIES.getKeyOrThrow(actualType).toString();
            String error = "Expected block entity at pos [%s] with type [%s], got [%s]".formatted(pos, CatnipServices.REGISTRIES.getKeyOrThrow(type), actualId);
            this.method_35995(error);
        }
        return (T)be;
    }

    public <T extends class_2586> T getControllerBlockEntity(class_2591<T> type, class_2338 anySegment) {
        Object be = ((IMultiBlockEntityContainer)this.getBlockEntity(type, anySegment)).getControllerBE();
        if (be == null) {
            this.method_35995("Could not get block entity controller with type [%s] from pos [%s]".formatted(CatnipServices.REGISTRIES.getKeyOrThrow(type), anySegment));
        }
        return be;
    }

    public <T extends BlockEntityBehaviour> T getBehavior(class_2338 pos, BehaviourType<T> type) {
        T behavior = BlockEntityBehaviour.get((class_1922)this.method_35943(), this.method_36052(pos), type);
        if (behavior == null) {
            this.method_35995("Behavior at " + String.valueOf(pos) + " missing, expected " + type.getName());
        }
        return behavior;
    }

    public class_1542 spawnItem(class_2338 pos, class_1799 stack) {
        class_243 spawn = class_243.method_24953((class_2382)this.method_36052(pos));
        class_3218 level = this.method_35943();
        class_1542 item = new class_1542((class_1937)level, spawn.field_1352, spawn.field_1351, spawn.field_1350, stack, 0.0, 0.0, 0.0);
        level.method_8649((class_1297)item);
        return item;
    }

    public <T extends class_1297> T spawnSeated(class_1299<T> type, class_2338 pos) {
        class_1297 entity = this.method_35964(type, pos);
        SeatBlock.sitDown((class_1937)this.method_35943(), this.method_36052(pos), entity);
        return (T)entity;
    }

    public void spawnItems(class_2338 pos, class_1792 item, int amount) {
        while (amount > 0) {
            int toSpawn = Math.min(amount, item.method_7882());
            amount -= toSpawn;
            class_1799 stack = new class_1799((class_1935)item, toSpawn);
            this.spawnItem(pos, stack);
        }
    }

    public <T extends class_1297> T getFirstEntity(class_1299<T> type, class_2338 pos) {
        List<T> list = this.getEntitiesBetween(type, pos.method_10095().method_10078().method_10084(), pos.method_10072().method_10067().method_10074());
        if (list.isEmpty()) {
            this.method_35995("No entities at pos: " + String.valueOf(pos));
        }
        return (T)((class_1297)list.get(0));
    }

    public <T extends class_1297> List<T> getEntitiesBetween(class_1299<T> type, class_2338 pos1, class_2338 pos2) {
        class_3341 box = class_3341.method_34390((class_2382)this.method_36052(pos1), (class_2382)this.method_36052(pos2));
        List entities = this.method_35943().method_18198(type, e -> box.method_14662((class_2382)e.method_24515()));
        return entities;
    }

    public Storage<FluidVariant> fluidStorageAt(class_2338 pos) {
        Storage storage = TransferUtil.getFluidStorage((class_1937)this.method_35943(), (class_2338)this.method_36052(pos));
        if (storage == null) {
            this.method_35995("storage not present");
        }
        return storage;
    }

    public FluidStack getTankContents(class_2338 tank) {
        Storage<FluidVariant> storage = this.fluidStorageAt(tank);
        return TransferUtil.firstOrEmpty(storage);
    }

    public long getTankCapacity(class_2338 pos) {
        Storage<FluidVariant> storage = this.fluidStorageAt(pos);
        return TransferUtil.totalCapacity(storage);
    }

    public long getFluidInTanks(class_2338 ... tanks) {
        long total = 0L;
        for (class_2338 tank : tanks) {
            total += this.getTankContents(tank).getAmount();
        }
        return total;
    }

    public void assertFluidPresent(FluidStack fluid, class_2338 pos) {
        FluidStack contained = this.getTankContents(pos);
        if (!fluid.isFluidEqual(contained)) {
            this.method_35995("Different fluids");
        }
        if (fluid.getAmount() != contained.getAmount()) {
            this.method_35995("Different amounts");
        }
    }

    public void assertTankEmpty(class_2338 pos) {
        this.assertFluidPresent(FluidStack.EMPTY, pos);
    }

    public void assertTanksEmpty(class_2338 ... tanks) {
        for (class_2338 tank : tanks) {
            this.assertTankEmpty(tank);
        }
    }

    public Storage<ItemVariant> itemStorageAt(class_2338 pos) {
        Storage storage = TransferUtil.getItemStorage((class_1937)this.method_35943(), (class_2338)this.method_36052(pos));
        if (storage == null) {
            this.method_35995("storage not present");
        }
        return storage;
    }

    public Object2LongMap<class_1792> getItemContent(class_2338 pos) {
        Storage<ItemVariant> storage = this.itemStorageAt(pos);
        Object2LongArrayMap map = new Object2LongArrayMap();
        try (Transaction t = TransferUtil.getTransaction();){
            for (StorageView view : storage.nonEmptyViews()) {
                ItemVariant resource = (ItemVariant)view.getResource();
                class_1792 item = resource.getItem();
                long amount = map.getLong((Object)item);
                map.put((Object)item, amount += view.extract((Object)resource, Long.MAX_VALUE, (TransactionContext)t));
            }
        }
        return map;
    }

    public long getTotalItems(class_2338 pos) {
        Storage<ItemVariant> storage = this.itemStorageAt(pos);
        try (Transaction t = TransferUtil.getTransaction();){
            long l = TransferUtil.extractAllAsStacks(storage).stream().mapToLong(class_1799::method_7947).sum();
            return l;
        }
    }

    public void assertAnyContained(class_2338 pos, class_1792 ... items) {
        Storage<ItemVariant> storage = this.itemStorageAt(pos);
        boolean noneFound = true;
        try (Transaction t = TransferUtil.getTransaction();){
            for (class_1792 item : items) {
                if (storage.extract((Object)ItemVariant.of((class_1935)item), 1L, (TransactionContext)t) <= 0L) continue;
                noneFound = false;
                break;
            }
        }
        if (noneFound) {
            this.method_35995("No matching items " + Arrays.toString(items) + " found in handler at pos: " + String.valueOf(pos));
        }
    }

    public void assertContentPresent(Object2LongMap<class_1792> content, class_2338 pos) {
        Storage<ItemVariant> storage = this.itemStorageAt(pos);
        Object2LongArrayMap missing = new Object2LongArrayMap();
        try (Transaction t = TransferUtil.getTransaction();){
            for (Object2LongMap.Entry entry : content.object2LongEntrySet()) {
                long extracted;
                class_1792 item = (class_1792)entry.getKey();
                long amount = entry.getLongValue();
                long remaining = amount - (extracted = storage.extract((Object)ItemVariant.of((class_1935)item), amount, (TransactionContext)t));
                if (remaining <= 0L) continue;
                missing.put((Object)item, remaining);
            }
        }
        if (!missing.isEmpty()) {
            this.method_35995("Storage missing content: " + String.valueOf(missing) + ", expected: " + String.valueOf(content));
        }
    }

    public void assertContainersEmpty(List<class_2338> positions) {
        for (class_2338 pos : positions) {
            this.method_36047(pos);
        }
    }

    public void method_36047(@NotNull class_2338 pos) {
        Storage<ItemVariant> storage = this.itemStorageAt(pos);
        storage.nonEmptyViews().forEach(view -> this.method_35995("Storage not empty"));
    }

    public void assertContainerContains(class_2338 pos, class_1935 item) {
        this.method_35983(pos, item.method_8389());
    }

    public void method_35983(@NotNull class_2338 pos, @NotNull class_1792 item) {
        this.assertContainerContains(pos, new class_1799((class_1935)item));
    }

    public void assertContainerContains(class_2338 pos, class_1799 item) {
        Storage<ItemVariant> storage = this.itemStorageAt(pos);
        class_1799 extracted = ItemHelper.extract(storage, stack -> ItemHandlerHelper.canItemStacksStack((class_1799)stack, (class_1799)item), item.method_7947(), true);
        if (extracted.method_7960()) {
            this.method_35995("item not present: " + String.valueOf(item));
        }
    }

    public void assertSecondsPassed(int seconds) {
        if (this.method_36045() < (long)seconds * 20L) {
            this.method_35995("Waiting for %s seconds to pass".formatted(seconds));
        }
    }

    public long secondsPassed() {
        return this.method_36045() % 20L;
    }

    public void whenSecondsPassed(int seconds, Runnable run) {
        this.method_36003((long)seconds * 20L, run);
    }

    public void assertCloseEnoughTo(double value, double expected) {
        this.assertInRange(value, expected - 1.0, expected + 1.0);
    }

    public void assertInRange(double value, double min, double max) {
        if (value < min) {
            this.method_35995("Value %s below expected min of %s".formatted(value, min));
        }
        if (value > max) {
            this.method_35995("Value %s greater than expected max of %s".formatted(value, max));
        }
    }

    @Contract(value="_->fail")
    public void method_35995(@NotNull String exceptionMessage) {
        super.method_35995(exceptionMessage);
    }
}

